# سیستم مدیریت خطا برای پنل مرزبان

## مشکل اصلی
وقتی دو ربات روی یک سرور اجرا می‌شوند و به یک پنل مرزبان متصل می‌شوند، ممکن است خطای "سرویس موردنظر در سرور پیدا نشد!" رخ دهد حتی اگر کاربر در پنل وجود داشته باشد.

## علت مشکل
1. **Token Cache**: وقتی دو ربات از یک دیتابیس استفاده می‌کنند، token cache مشترک است و ممکن است token منقضی شده باشد
2. **Token Expiration**: محاسبه زمان token ممکن است مشکل داشته باشد
3. **401/403 Errors**: وقتی token منقضی می‌شود، API خطای 401 برمی‌گرداند
4. **Missing Inbounds**: کاربر در پنل وجود دارد ولی اینباند تنظیم نشده

## راه‌حل پیاده‌سازی شده

### 1. بهبود Token Management (`Marzban.php`)
- بهبود محاسبه زمان token (از 60 دقیقه به 50 دقیقه کاهش یافت برای اطمینان)
- بررسی صحت token قبل از استفاده
- مدیریت بهتر خطاهای strtotime

### 2. سیستم Retry با Token Refresh (`error_handler.php`)
- تابع `ensureValidToken()`: بررسی و refresh خودکار token
- تابع `handleGetUserError()` با retry: اگر خطای 401/403 دریافت شد، token را refresh می‌کند و دوباره تلاش می‌کند
- تشخیص دقیق‌تر خطاها

### 3. پیام‌های بهتر
- تشخیص اینکه کاربر پیدا شده ولی اینباند ندارد
- راهنمایی‌های واضح برای رفع مشکل
- لاگ‌گیری کامل برای دیباگ

## نحوه استفاده

سیستم به صورت خودکار فعال است. فقط کافی است:

```php
$errorCheck = handleGetUserError($response, $username, $panel_name, $code_panel);
```

پارامتر `$code_panel` برای retry و token refresh استفاده می‌شود.

## فایل‌های لاگ

لاگ‌ها در مسیر زیر ذخیره می‌شوند:
```
storage/cache/error_log_YYYY-MM-DD.txt
```

## نکات مهم

1. **Token Cache**: اگر مشکل ادامه داشت، می‌توانید token cache را پاک کنید:
   ```sql
   UPDATE marzban_panel SET datelogin = NULL;
   ```

2. **Multiple Bots**: اگر دو ربات روی یک سرور هستند، مطمئن شوید که:
   - هر دو از یک دیتابیس استفاده می‌کنند (برای cache مشترک)
   - یا از دیتابیس‌های جداگانه استفاده می‌کنند

3. **Panel Restart**: اگر مشکل ادامه داشت، پنل مرزبان را restart کنید

## تست

برای تست سیستم:
1. یک کاربر در پنل ایجاد کنید
2. اینباند را برای آن کاربر تنظیم کنید
3. نام کاربری را در بخش تنظیم اینباند ربات وارد کنید
4. اگر خطا داد، لاگ‌ها را بررسی کنید

